<?php

namespace Modules\Tax\Sales;

use Illuminate\Database\Eloquent\Model;

class MemoType extends Model 
{

    protected $table = 'memo_types';
    public $timestamps = true;

    public function fiscal_document_type()
    {
        return $this->belongsTo('FiscalDocumentType');
    }

    public function accounting_nature()
    {
        return $this->belongsTo('AccountingNature');
    }

    public function contact_type()
    {
        return $this->belongsTo('ContactType');
    }

    public function document_type_series()
    {
        return $this->morphMany('DocumentTypeSerie', 'serieable');
    }

    public function document_type_issuing_services()
    {
        return $this->morphMany('DocumentTypeIssuingService', 'serviceable');
    }

}